<?php
function generateSchema($url, $h1, $title, $description) {
    $fullUrl = 'https://' . $_SERVER['HTTP_HOST'] . '/' . ltrim($url, '/') . (substr($url, -1) !== '/' ? '/' : '');
    $domain = $_SERVER['HTTP_HOST'];
    $logo = 'https://' . $domain . '/logo.svg';
    $today = date('Y-m-d');
    $twitterHandle = '@' . preg_replace('/^www\./', '', $domain);

    $hash = crc32($domain);
    $randDigits = abs((int)($hash % 10000000));
    $randDigitsStr = str_pad($randDigits, 7, '0', STR_PAD_LEFT);
    $phone = "+7-495-$randDigitsStr";

    $domainNameParts = explode('.', $domain);
    $domainShort = $domainNameParts[0];

    $domainZone = substr($domain, 0, 2);
    $isoDate = date('c'); // Пример: 2025-04-01T00:00:00+03:00

$schemaArticle = [
    "@context" => "https://schema.org",
    "@type" => "Article",
    "mainEntityOfPage" => [
        "@type" => "WebPage",
        "@id" => $fullUrl
    ],
    "headline" => $h1,
    "name" => $title,
    "description" => $description,
    "image" => $logo,
    "author" => [
        "@type" => "Organization",
        "name" => $domain,
        "url" => "https://$domain"
    ],
    "publisher" => [
        "@type" => "Organization",
        "name" => $domain,
        "logo" => [
            "@type" => "ImageObject",
            "url" => $logo
        ]
    ],
    "datePublished" => $isoDate,
    "dateModified" => $isoDate
];


    $jsonLdArticle = '<script type="application/ld+json">' . json_encode($schemaArticle, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) . '</script>';

    $schemaOrg = [
        "@context" => "https://schema.org",
        "@type" => "Organization",
        "name" => $domain,
        "url" => "https://$domain",
        "logo" => [
            "@type" => "ImageObject",
            "url" => $logo,
            "width" => 300,
            "height" => 60
        ],
        "sameAs" => [
            "https://vk.com/$domainShort",
            "https://facebook.com/$domainShort",
            "https://t.me/$domainShort"
        ],
        "description" => $description,
        "contactPoint" => [
            "@type" => "ContactPoint",
            "telephone" => $phone,
            "contactType" => "Customer Support",
            "areaServed" => "RU",
            "availableLanguage" => ["Russian"]
        ]
    ];

    $jsonLdOrg = '<script type="application/ld+json">' . json_encode($schemaOrg, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) . '</script>';

    $metaTags = <<<META
<meta property="og:type" content="article">
<meta property="og:title" content="$title">
<meta property="og:description" content="$description">
<meta property="og:url" content="$fullUrl">
<meta property="og:image" content="$logo">
<meta property="og:site_name" content="$domain">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="$title">
<meta name="twitter:description" content="$description">
<meta name="twitter:image" content="$logo">
<meta name="twitter:site" content="$twitterHandle">
META;

    // --------------------------
    // 🔷 Статичные списки имён и фамилий
    $firstNames = ["Иван", "Сергей", "Алексей", "Дмитрий", "Михаил", "Николай", "Андрей", "Евгений"];
    $lastNames  = ["Петров", "Иванов", "Сидоров", "Кузнецов", "Смирнов", "Фёдоров", "Алексеев", "Морозов"];

    $hash = crc32($domain);

    // Получаем 3 уникальные комбинации
    $person1 = $firstNames[($hash + 1) % count($firstNames)] . ' ' . $lastNames[($hash + 2) % count($lastNames)];
    $person2 = $firstNames[($hash + 3) % count($firstNames)] . ' ' . $lastNames[($hash + 4) % count($lastNames)];
    $person3 = $firstNames[($hash + 5) % count($firstNames)] . ' ' . $lastNames[($hash + 6) % count($lastNames)];

    // Домен без зоны
    $publisherName = explode('.', $domain)[0];

 $domainZone = substr($domain, 0, 2);

$schemaByPeople = [
    "@context" => "https://schema.org",
    "@type" => "Article",
    "author" => [
        "@type" => "Person",
        "name" => $person1,
        "url" => "https://$domain/author-1-$domainZone/"
    ],
    "editor" => [
        "@type" => "Person",
        "name" => $person2,
        "url" => "https://$domain/author-2-$domainZone/"
    ],
    "contributor" => [
        "@type" => "Person",
        "name" => $person3,
        "url" => "https://$domain/author-3-$domainZone/"
    ],
    "publisher" => [
        "@type" => "Organization",
        "name" => $publisherName
    ],
    "articleBody" => $description
];

    $jsonLdPeople = '<script type="application/ld+json">' . json_encode($schemaByPeople, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) . '</script>';

    // --------------------------
    // JSON-LD: WebSite + SearchAction
    $schemaWebSite = [
        "@context" => "https://schema.org",
        "@type" => "WebSite",
        "name" => $h1,
        "url" => "https://$domain",
        "potentialAction" => [
            "@type" => "SearchAction",
            "target" => "https://$domain/search?q={search_term_string}",
            "query-input" => "required name=search_term_string"
        ]
    ];

    $jsonLdWebsite = '<script type="application/ld+json">' . json_encode($schemaWebSite, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) . '</script>';


return $jsonLdArticle
     . "\n" . $jsonLdOrg
     . "\n" . $jsonLdPeople
     . "\n" . $jsonLdWebsite
     . "\n" . $metaTags;


}
